;***********************************************************************************************************************
;* 150130-03
;*
;*    SUPER JOYSTICK PORT 2
;*
;*     USB-RECORDER  ATMEGA8515
;*      -   DIP-32 FLASHER  ATMEGA8515
;*
;*      ATMEGA8515   11,0592 
;*
;* (C) 2015    (zst, www.zxkit.ru)
;***********************************************************************************************************************

.include "m8515def.inc"
.include "MACRO.asm"
.include "EQU.asm"
.include "DEF.asm"

;***********************************************************************************************************************
;* 120812                                  
;***********************************************************************************************************************
.org    $000
rjmp    RESET                           ; Reset Handler
reti;   rjmp EXT_INT0                   ; IRQ0 Handler
reti;   rjmp EXT_INT1                   ; IRQ1 Handler
reti;   rjmp TIM1_CAPT                  ; Timer1 Capture Handler
rjmp    TIM1_COMPA                      ; Timer1 Compare A Handler
reti;   rjmp TIM1_COMPB                 ; Timer1 Compare B Handler
reti;   rjmp TIM1_OVF                   ; Timer1 Overflow Handler
reti;   rjmp TIM0_OVF                   ; Timer0 Overflow Handler
reti;   rjmp SPI_STC                    ; SPI Transfer Complete Handler
reti;   rjmp USART_RXC                  ; USART RX Complete Handler
reti;   rjmp USART_UDRE                 ; UDR0 Empty Handler
reti;   rjmp USART_TXC                  ; USART TX Complete Handler
reti;   rjmp ANA_COMP                   ; Analog Comparator Handler
reti;   rjmp EXT_INT2                   ; IRQ2 Handler
reti;   rjmp TIM0_COMP                  ; Timer0 Compare Handler
reti;   rjmp EE_RDY                     ; EEPROM Ready Handler
reti;   rjmp SPM_RDY                    ; Store Program memory Ready

RESET:
        jmp MAIN                        ;    
.org    $100
.include "DATA.asm"                     ;    FLASH    

;***********************************************************************************************************************
;* 150130-03                              
;***********************************************************************************************************************
MAIN:   ldi     temp,low(RAMEND)        ;     
        out     SPL,temp
        ldi     temp,high(RAMEND)
        out     SPH,temp
;--------------------------------------   - --------------------------------------------------

        INIT_ANOTHER_PORTS              ;     -
        CLR_REG_SHIFT                   ;       
        CLR_REG_LATCH                   ;       
        SET_SEGA12_7                    ;     SEGA 

;--------------------------------------     ----------------------------------------

        ldi     digit1,0                ;    - 01
        ldi     digit0,1

        ldi     indic_digit,0b10000000  ;      
        ldi     fontsAdr,low(2*FONTS)   ;      
        clr     indic_count             ;    

        ldi     XH,$01                  ;    X   Y
        ldi     XL,$00                  ;        $0100 
        ldi     YH,$01  
        ldi     YL,$00                  ;    ,  

;--------------------------------------     1   44100  --------------------------

        ldi     temp,0b00001001         ;   CTC   A,   
        out     TCCR1B,temp

        ldi     temp,0b00001000         ;   CTC   A,   A   0
        out     TCCR1A,temp             ;     OC1A

        ldi     temp,high(271)          ;   A -  1    0  A=271
        out     OCR1AH,temp             ;      12000000/272=44117,647 
        ldi     temp,low(271)
        out     OCR1AL,temp

        clr     temp                    ;    1     
        out     TCNT1H,temp
        out     TCNT1L,temp

        ldi     temp,(1<<OCIE1A)        ;     1   CTC   A
        out     TIMSK,temp

        sei                             ;   
          
;--------------------------------------   -    -------------------------
;                                            
MAIN_LOOP:

                                        ; !!!    -     
        
        rjmp    MAIN_LOOP
        
;***********************************************************************************************************************
;* 120813                                    1
;***********************************************************************************************************************
TIM1_COMPA:
        in      temp2,SREG              ;      
        push    temp2

        cpi     mode,LOAD               ;    -  LOAD 
        brne    TIM1_10

;----------------------------------------    USB-   -------------------------------

LOAD_00:cp      XL,YL                   ;    - 
        breq    TIM1_10
        
        ld      temp2,X                 ;        X
        cpi     temp2,0         
        brne    LOAD_10                 ;     0,    
        
        nop                             ;  1       
        CLR_DIGITAL_OUT                 ;     = 0
        rjmp    LOAD_20
        
LOAD_10:SET_DIGITAL_OUT                 ;     = 1
LOAD_20:inc     XL                      ;        
        rjmp    TIM1_20 

;-----------------------------------------------------------------------------------------------------------------------

TIM1_10:cpi     mode,SAVE               ;    -  SAVE 
        brne    TIM1_20

;--------------------------------------      USB- -----------------------------------

SAVE_00:TST_DIGITAL_IN                  ;    
        brne    SAVE_10                 ;     0,    
        
        ldi     temp2,$00               ;     0 -     $00
        st      Y,temp2
        rjmp    SAVE_20
        
SAVE_10:ldi     temp2,$FF               ;     1 -     $FF
        st      Y,temp2
SAVE_20:inc     YL                      ;        

        cp      XL,YL                   ;     - 
        brne    TIM1_20
                                        ;  :
        dec     YL                      ;        
        
TIM1_20:
;-----------------------------------------------------------------------------------------------------------------------

                                        ; !!!       
                                        ; !!!       

;--------------------------------------       ---------------------

INDIC_0:inc     indic_count             ;  256-  (  172 ) - 
        brne    INDIC_END

        ldi     ZH,high(2*FONTS)        ;     
        mov     ZL,fontsAdr
        
        com     indic_digit             ;  -    
        brmi    INDIC_DIG1              ;        
        
INDIC_DIG0:                             ; 0 -     :
        OFF_DIGIT1                      ;     

        add     ZL,digit0               ;      
        lpm     temp2,Z                 ;    
    
        OUT_SEGMENTS                    ;       
        
        ON_DIGIT0                       ;      
        rjmp    INDIC_END
        
INDIC_DIG1:                             ; 1 -     :
        OFF_DIGIT0                      ;     

        add     ZL,digit1               ;      
        lpm     temp2,Z                 ;    
    
        OUT_SEGMENTS                    ;       

        ON_DIGIT1                       ;      
INDIC_END:
       
;--------------------------------------      1 --------------------------------

        pop     temp2                   ;    
        out     SREG,temp2
        reti                            ;       

;***********************************************************************************************************************
